#version 430

layout(location = 0) out vec4 f_Bloom;

in vec2 TexCoords;

layout (binding = 0) uniform sampler2D BloomInput;
layout (binding = 1) uniform sampler2D solarInput;

uniform int horizontal;
uniform int firstPass;
 
uniform float weight[5] = float[] (0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);
uniform float solarBrightness = 1.5f;
int sampleCount = 5;

vec4 getBloomData(vec2 coordinates){
	vec4 bloomResult = texture(BloomInput, coordinates).rgba;

	return bloomResult;

}

void main()
{       
	
	
	vec4 bloomResult = vec4(0.0);

	float BloomTexOffset = 1.0;

	bool gotSolarBrightness = false;

	
	if(firstPass == 1){
		vec3 solarBloom = texture(solarInput, TexCoords).rgb;

		if(length(solarBloom) > 0.0){
			gotSolarBrightness = true;
			bloomResult.xyz += solarBloom;
			bloomResult.w = 0.5;
		}
	}
	

	if(!gotSolarBrightness){
		bloomResult += getBloomData(TexCoords) * 0.5;
	}

	vec2 texOffsetBloom = BloomTexOffset / textureSize(BloomInput, 0);
	vec2 texOffsetSolar = BloomTexOffset / textureSize(solarInput, 0);

   if(horizontal == 1)
   {
     for(int i = 1; i < sampleCount; ++i)
     {
		
		if(!gotSolarBrightness){
			bloomResult += getBloomData(TexCoords + vec2(texOffsetBloom.x * i, 0.0)) * weight[i];
			bloomResult += getBloomData(TexCoords - vec2(texOffsetBloom.x * i, 0.0)) * weight[i];
		}

		bloomResult.xyz += texture(solarInput, TexCoords + vec2(texOffsetSolar.x * i, 0.0)).rgb * weight[i];
		bloomResult.xyz += texture(solarInput, TexCoords - vec2(texOffsetSolar.x * i, 0.0)).rgb * weight[i];

     }
   }
   else
   {
     for(int i = 1; i < sampleCount; ++i)
     {
		bloomResult += getBloomData(TexCoords + vec2(0.0, texOffsetBloom.y * i)) * weight[i];
		bloomResult += getBloomData(TexCoords - vec2(0.0, texOffsetBloom.y * i)) * weight[i];

     }
   }

	f_Bloom = bloomResult;

}




	/*


   */
